package org.msh.tb.reports2.me;

import org.msh.tb.reports2.ReportResources;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class CohortIPTReport {

    public static List<TableData> generate(IndicatorBuilder builder) {
        List<TableData> tables = new ArrayList<TableData>();

        tables.add(generateTable1(builder));

        tables.add(generateTable2(builder.clear()));

        tables.add(generateTable3(builder.clear()));

        tables.add(generateTable4(builder.clear()));

        return tables;
    }

    private static TableData generateTable1(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(ReportResources.VAR_AGERANGE3)
                .addRowVariables(ReportResources.VAR_PATIENTTYPE, ReportResources.VAR_GENDER)
                .addFilter(ReportResources.VAR_CLASSIFICATION, "0")  // DS-TB
                .generate("DS-TB contacts");

        return tbl;
    }

    private static TableData generateTable2(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(ReportResources.VAR_AGERANGE3)
                .addRowVariables(ReportResources.VAR_PATIENTTYPE, ReportResources.VAR_GENDER)
                .addFilter(ReportResources.VAR_CLASSIFICATION, "1")  // DR-TB
                .generate("DR-TB contacts");

        return tbl;
    }

    private static TableData generateTable3(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(ReportResources.VAR_AGERANGE3)
                .addRowVariables(ReportResources.VAR_PATIENTTYPE, ReportResources.VAR_GENDER)
                .generate("All contacts");

        return tbl;
    }

    private static TableData generateTable4(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(ReportResources.VAR_AGERANGE3)
                .addRowVariables(ReportResources.VAR_PATIENTTYPE, ReportResources.VAR_GENDER)
                .generate("Children <= 6 yrs contacts identified");

        return tbl;
    }
}
